/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.paymentpart;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.layout.Dimension;
import ch.codeblock.qrinvoice.layout.DimensionUnitUtils;
import ch.codeblock.qrinvoice.layout.Rect;
import ch.codeblock.qrinvoice.paymentpart.IPaymentPartWriter;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractItextPaymentPartWriter
implements IPaymentPartWriter {
    protected static final String CHARSET = QrInvoiceSpec.ENCODING.name();
    protected static final int TITLE_FONT_SIZE = 11;
    protected static final int HEADING_FONT_SIZE = 7;
    protected static final int VALUE_FONT_SIZE = 9;
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    protected static final Rect<Float> A6_LANDSCAPE = Rect.create(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(420.0f), Float.valueOf(297.0f));
    protected static final float QUIET_SPACE_PTS = DimensionUnitUtils.millimetersToPoints(5.0f);
    protected static final float BOX_CORNER_LENGTH = DimensionUnitUtils.millimetersToPoints(3.5f);
    protected static final Dimension<Float> AMOUNT_FIELD = AbstractItextPaymentPartWriter.mmToPoints(QrInvoiceSpec.AMOUNT_FIELD);
    protected static final Dimension<Float> AMOUNT_SECTION = AbstractItextPaymentPartWriter.mmToPoints(QrInvoiceSpec.AMOUNT_SECTION);
    protected static final Dimension<Float> DEBTOR_FIELD = AbstractItextPaymentPartWriter.mmToPoints(QrInvoiceSpec.DEBTOR_FIELD);
    protected static final Rect<Float> QR_CODE_RECTANGLE;
    protected static final Rect<Float> INFORMATION_SECTION_RECT;
    private ResourceBundle labels;

    protected static Dimension<Float> mmToPoints(Dimension<Integer> mmDimension) {
        return new Dimension<Float>(Float.valueOf(DimensionUnitUtils.millimetersToPoints(mmDimension.getWidth().intValue())), Float.valueOf(DimensionUnitUtils.millimetersToPoints(mmDimension.getHeight().intValue())));
    }

    protected static float getPaymentPartWidth() {
        return ((Float)A6_LANDSCAPE.getWidth()).floatValue();
    }

    protected static float getPaymentPartHeight() {
        return ((Float)A6_LANDSCAPE.getHeight()).floatValue();
    }

    public AbstractItextPaymentPartWriter(Locale locale) {
        this.labels = ResourceBundle.getBundle("qrinvoice", locale);
    }

    @Override
    public int getQrCodeImageSize() {
        int dpi = 300;
        float mm = QrInvoiceSpec.QR_CODE_SIZE.getWidth().intValue();
        float mmPerInch = 25.4f;
        return Math.round(300.0f * mm / 25.4f);
    }

    protected String getLabel(String key) {
        return this.labels.getString(key);
    }

    static {
        float x = QUIET_SPACE_PTS;
        float y = QUIET_SPACE_PTS * 2.0f + AMOUNT_SECTION.getHeight().floatValue();
        QR_CODE_RECTANGLE = Rect.createUsingDimension(Float.valueOf(x), Float.valueOf(y), AbstractItextPaymentPartWriter.mmToPoints(QrInvoiceSpec.QR_CODE_SIZE));
        x = QUIET_SPACE_PTS + ((Float)QR_CODE_RECTANGLE.getWidth()).floatValue() + QUIET_SPACE_PTS * 3.0f;
        y = QUIET_SPACE_PTS;
        float height = AbstractItextPaymentPartWriter.getPaymentPartHeight() - DimensionUnitUtils.millimetersToPoints(20.0f);
        float width = DimensionUnitUtils.millimetersToPoints(50.0f);
        INFORMATION_SECTION_RECT = Rect.createUsingDimension(Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
    }
}

