/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.paymentpart;

import ch.codeblock.qrinvoice.NotYetImplementedException;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.PageSize;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.mapper.ModelToSwissPaymentsCodeMapper;
import ch.codeblock.qrinvoice.paymentpart.IPaymentPartWriter;
import ch.codeblock.qrinvoice.paymentpart.IPaymentPartWriterFactory;
import ch.codeblock.qrinvoice.qrcode.SwissQrCodeWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentPartWriter {
    private final Logger logger = LoggerFactory.getLogger(PaymentPartWriter.class);

    public byte[] write(PageSize pageSize, OutputFormat outputFormat, Locale locale, QrInvoice qrInvoice) {
        IPaymentPartWriter paymentPartWriter = this.selectPaymentPartWriter(pageSize, outputFormat, locale);
        int pixels = paymentPartWriter.getQrCodeImageSize();
        String swissPaymentsCode = new ModelToSwissPaymentsCodeMapper().map(qrInvoice).toSwissPaymentsCodeString();
        byte[] qrCodeImage = new SwissQrCodeWriter().write(OutputFormat.PNG, swissPaymentsCode, pixels);
        return paymentPartWriter.write(qrInvoice, qrCodeImage);
    }

    private IPaymentPartWriter selectPaymentPartWriter(PageSize pageSize, OutputFormat outputFormat, Locale locale) {
        switch (outputFormat) {
            case PDF: {
                ServiceLoader<IPaymentPartWriterFactory> partWriterFactories = ServiceLoader.load(IPaymentPartWriterFactory.class);
                Iterator<IPaymentPartWriterFactory> iterator = partWriterFactories.iterator();
                IPaymentPartWriterFactory selectedPaymentPartWriter = iterator.next();
                if (iterator.hasNext()) {
                    this.logger.warn("There is currently more than one implementation of IPaymentPartWriterFactory available at runtime. The following has been chosen to work with: {}", selectedPaymentPartWriter.getClass());
                }
                return selectedPaymentPartWriter.create(pageSize, locale);
            }
        }
        throw new NotYetImplementedException("Output Format " + (Object)((Object)outputFormat) + " has not yet been implemented");
    }
}

