/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.TechnicalException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class CountryUtils {
    private static final Properties COUNTRIES = new Properties();

    private CountryUtils() {
    }

    public static boolean isValidIsoCode(String countryCode) {
        if ("CH".equals(countryCode)) {
            return true;
        }
        if (countryCode == null || countryCode.length() != 2) {
            return false;
        }
        return COUNTRIES.containsKey(countryCode);
    }

    static {
        try (InputStream is = CountryUtils.class.getResourceAsStream("/ch/codeblock/qrinvoice/standards/iso3166-1.properties");){
            COUNTRIES.load(is);
        }
        catch (IOException e) {
            throw new TechnicalException("Unable to read country codes", e);
        }
    }
}

