/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.util.StringUtils;
import java.math.BigInteger;
import java.util.stream.Collectors;

public final class CreditorReferenceUtils {
    private static final String PREFIX = "RF";
    private static final int MIN_LENGTH = 4;
    private static final int MAX_LENGTH = 25;
    private static final BigInteger MOD_97 = new BigInteger("97");
    private static final BigInteger MOD_97_REMAINDER = BigInteger.ONE;

    private CreditorReferenceUtils() {
    }

    public static boolean isValid(String creditorReferenceInput) {
        if (creditorReferenceInput == null) {
            return false;
        }
        String creditorReference = StringUtils.removeWhitespaces(creditorReferenceInput);
        int length = creditorReference.length();
        if (4 > length || length > 25) {
            return false;
        }
        if (!creditorReference.startsWith(PREFIX)) {
            return false;
        }
        String creditorReferenceRearranged = creditorReference.substring(4) + creditorReference.substring(0, 4);
        String numericCreditorReference = creditorReferenceRearranged.chars().map(Character::getNumericValue).mapToObj(String::valueOf).collect(Collectors.joining());
        BigInteger creditorReferenceNumber = new BigInteger(numericCreditorReference);
        return creditorReferenceNumber.mod(MOD_97).equals(MOD_97_REMAINDER);
    }
}

