/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.QrInvoiceSpec;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.math.BigInteger;
import java.util.stream.Collectors;

public final class IbanUtils {
    private static final int CHARS_PER_BLOCK = 4;
    private static final int MIN_LENGTH = 15;
    private static final int MAX_LENGTH = 34;
    private static final BigInteger MOD_97 = new BigInteger("97");
    private static final BigInteger MOD_97_REMAINDER = BigInteger.ONE;
    private static final int QR_IID_RANGE_START = 30000;
    private static final int QR_IID_RANGE_END = 31999;

    private IbanUtils() {
    }

    public static String formatIban(String ibanInput) {
        if (ibanInput == null) {
            return "";
        }
        String iban = StringUtils.removeWhitespaces(ibanInput);
        StringBuilder ibanBuffer = new StringBuilder(iban);
        int numberOfBlocks = iban.length() / 4;
        for (int blockNr = 1; blockNr <= numberOfBlocks; ++blockNr) {
            ibanBuffer.insert(blockNr * 4 + blockNr - 1, ' ');
        }
        return ibanBuffer.toString();
    }

    public static boolean isValidIBAN(String ibanInput, boolean validateCountryCode) {
        if (ibanInput == null) {
            return false;
        }
        String iban = StringUtils.removeWhitespaces(ibanInput);
        int len = iban.length();
        if (len < 15 || len > 34) {
            return false;
        }
        String ibanRearranged = iban.substring(4) + iban.substring(0, 4);
        String numericIBAN = ibanRearranged.chars().map(Character::getNumericValue).mapToObj(String::valueOf).collect(Collectors.joining());
        BigInteger ibanNumber = new BigInteger(numericIBAN);
        boolean ibanValid = ibanNumber.mod(MOD_97).equals(MOD_97_REMAINDER);
        if (ibanValid && validateCountryCode) {
            return IbanUtils.validateCountryCode(iban);
        }
        return ibanValid;
    }

    private static boolean validateCountryCode(String iban) {
        String countryCode = iban.substring(0, 2);
        return QrInvoiceSpec.SUPPORTED_IBAN_COUNTRIES.contains(countryCode);
    }

    public static boolean isQrIBAN(String ibanInput) {
        if (ibanInput == null) {
            return false;
        }
        String iban = StringUtils.removeWhitespaces(ibanInput);
        if (!IbanUtils.isValidIBAN(iban, false)) {
            return false;
        }
        int iid = Integer.parseInt(iban.substring(4, 9));
        return 30000 <= iid && iid <= 31999;
    }
}

