/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.NotYetImplementedException;
import java.math.BigDecimal;
import java.util.Objects;

public class NumberUtils {
    public static <T extends Number> T subtract(T from, T subtract) {
        if (Objects.isNull(from) || Objects.isNull(subtract)) {
            throw new IllegalArgumentException("only non-null values must be passed");
        }
        if (from instanceof Integer) {
            return (T)Integer.valueOf(from.intValue() - subtract.intValue());
        }
        if (from instanceof Float) {
            return (T)Float.valueOf(from.floatValue() - subtract.floatValue());
        }
        if (from instanceof Double) {
            return (T)Double.valueOf(from.doubleValue() - subtract.doubleValue());
        }
        if (from instanceof Long) {
            return (T)Long.valueOf(from.longValue() - subtract.longValue());
        }
        if (from instanceof Short) {
            return (T)Short.valueOf((short)(from.shortValue() - subtract.shortValue()));
        }
        if (from instanceof BigDecimal) {
            return (T)((BigDecimal)from).subtract((BigDecimal)subtract);
        }
        throw new NotYetImplementedException();
    }

    public static <T extends Number> T add(T a, T b) {
        if (Objects.isNull(a) || Objects.isNull(b)) {
            throw new IllegalArgumentException("only non-null values must be passed");
        }
        if (a instanceof Integer) {
            return (T)Integer.valueOf(a.intValue() + b.intValue());
        }
        if (a instanceof Float) {
            return (T)Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Double) {
            return (T)Double.valueOf(a.doubleValue() + b.doubleValue());
        }
        if (a instanceof Long) {
            return (T)Long.valueOf(a.longValue() + b.longValue());
        }
        if (a instanceof Short) {
            return (T)Short.valueOf((short)(a.shortValue() + b.shortValue()));
        }
        if (a instanceof BigDecimal) {
            return (T)((BigDecimal)a).add((BigDecimal)b);
        }
        throw new NotYetImplementedException();
    }
}

