/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import ch.codeblock.qrinvoice.util.StringUtils;

public final class QRReferenceUtils {
    private static final int LENGTH = 27;
    private static final int[] DIGIT_TABLE = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    private QRReferenceUtils() {
    }

    public static boolean isValid(String qrReferenceInput) {
        if (qrReferenceInput == null) {
            return false;
        }
        String qrReference = StringUtils.removeWhitespaces(qrReferenceInput);
        if (27 != qrReference.length()) {
            return false;
        }
        String qrReferenceWithoutChecksumDigit = qrReference.substring(0, 26);
        int checksumDigit = Character.getNumericValue(qrReference.charAt(26));
        return QRReferenceUtils.modulo10Recurisve(qrReferenceWithoutChecksumDigit) == checksumDigit;
    }

    private static int modulo10Recurisve(String nummer) {
        int transfer = 0;
        for (char c : nummer.toCharArray()) {
            int digit = Character.getNumericValue(c);
            transfer = DIGIT_TABLE[(transfer + digit) % 10];
        }
        return (10 - transfer) % 10;
    }
}

