/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.util;

import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("[-+]?\\d*\\.?\\d+");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String emptyStringAsNull(String str) {
        if (str != null && str.isEmpty()) {
            return null;
        }
        return str;
    }

    public static boolean isNumeric(String s) {
        return s != null && NUMERIC_PATTERN.matcher(s).matches();
    }

    public static String removeWhitespaces(String ibanInput) {
        return WHITESPACE_PATTERN.matcher(ibanInput).replaceAll("");
    }
}

