package ch.codeblock.qrinvoice.paymentpart;

import ch.codeblock.qrinvoice.OutputFormat;

public class IText5PaymentPartWriterFactory implements IPaymentPartWriterFactory{

    @Override
    public boolean supports(final PaymentPartWriterOptions options) {
        return options.getOutputFormat().equals(OutputFormat.PDF);
    }
    
    @Override
    public IPaymentPartWriter create(final PaymentPartWriterOptions options) {
        return new IText5PaymentPartWriter(options);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName();
    }
    
    @Override
    public String getShortName() {
        return getClass().getSimpleName().replace("PaymentPartWriterFactory", "");
    }
}
