/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.paymentpart;

import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.TechnicalException;
import ch.codeblock.qrinvoice.layout.LayoutException;
import ch.codeblock.qrinvoice.layout.Point;
import ch.codeblock.qrinvoice.layout.Rect;
import ch.codeblock.qrinvoice.model.Address;
import ch.codeblock.qrinvoice.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.model.PaymentReference;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.util.AddressUtils;
import ch.codeblock.qrinvoice.output.PaymentPart;
import ch.codeblock.qrinvoice.paymentpart.AbstractItextPaymentPartWriter;
import ch.codeblock.qrinvoice.paymentpart.IPaymentPartWriter;
import ch.codeblock.qrinvoice.paymentpart.PaymentPartWriterOptions;
import ch.codeblock.qrinvoice.util.DecimalFormatFactory;
import ch.codeblock.qrinvoice.util.IbanUtils;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.SplitCharacter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.function.Function;

public class IText5PaymentPartWriter
extends AbstractItextPaymentPartWriter
implements IPaymentPartWriter {
    private final Rectangle pageCanvas;
    private final Point<Float> rootLowerLeft;
    private final Rectangle informationSectionRect;
    private BaseFont regularFont;
    private BaseFont boldFont;
    private Font headingFont;
    private Font valueFont;
    private static final SplitOnAllCharacters SPLIT_ON_ALL_CHARACTERS = new SplitOnAllCharacters();

    public IText5PaymentPartWriter(PaymentPartWriterOptions options) {
        super(options);
        switch (options.getPageSize()) {
            case A4: {
                this.pageCanvas = PageSize.A4;
                break;
            }
            case A5: {
                this.pageCanvas = PageSize.A5.rotate();
                break;
            }
            default: {
                this.pageCanvas = PageSize.A6.rotate();
            }
        }
        this.rootLowerLeft = new Point((Number)Float.valueOf(this.pageCanvas.getWidth() - IText5PaymentPartWriter.getPaymentPartWidth()), (Number)Float.valueOf(0.0f));
        this.informationSectionRect = this.itextRectangle((Rect<Float>)INFORMATION_SECTION_RECT.move(this.rootLowerLeft));
        try {
            this.boldFont = BaseFont.createFont((String)"Helvetica-Bold", (String)CHARSET, (boolean)true);
            this.regularFont = BaseFont.createFont((String)"Helvetica", (String)CHARSET, (boolean)true);
            this.headingFont = new Font(this.boldFont, 6.0f);
            this.valueFont = new Font(this.regularFont, 8.0f);
        }
        catch (Exception e) {
            throw new TechnicalException("Error while creating fonts", (Throwable)e);
        }
    }

    public PaymentPart write(QrInvoice qrInvoice, BufferedImage qrCodeImage) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(25600);
            Document document = new Document(this.pageCanvas, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            this.addTitleSection(writer);
            this.addQrCodeImage(writer, qrCodeImage);
            this.addAmount(writer, qrInvoice.getPaymentAmountInformation());
            this.addInformationSection(writer, qrInvoice);
            this.drawPaymentPartBoundaryLines(writer.getDirectContent());
            document.close();
            return new PaymentPart(OutputFormat.PDF, baos.toByteArray());
        }
        catch (DocumentException | IOException e) {
            throw new TechnicalException("Unexpected exception occurred during the creation of the payment part", e);
        }
    }

    private void addTitleSection(PdfWriter writer) {
        PdfContentByte content = writer.getDirectContent();
        content.beginText();
        float x = ((Float)this.rootLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS;
        content.setFontAndSize(this.headingFont.getBaseFont(), 11.0f);
        content.showTextAligned(0, this.getLabel("Title"), x, IText5PaymentPartWriter.getPaymentPartHeight() - 20.0f, 0.0f);
        content.setFontAndSize(this.headingFont.getBaseFont(), 6.0f);
        content.showTextAligned(0, this.getLabel("Subtitle"), x, IText5PaymentPartWriter.getPaymentPartHeight() - 30.0f, 0.0f);
        content.setFontAndSize(this.regularFont, 8.0f);
        content.showTextAligned(0, this.getLabel("Transfer"), x, IText5PaymentPartWriter.getPaymentPartHeight() - 42.0f, 0.0f);
        content.endText();
    }

    private void addQrCodeImage(PdfWriter writer, BufferedImage qrCodeImage) throws IOException, DocumentException {
        com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((Image)qrCodeImage, null);
        Rect absolutePos = QR_CODE_RECTANGLE.move(this.rootLowerLeft);
        image.setAbsolutePosition(((Float)absolutePos.getLowerLeftX()).floatValue(), ((Float)absolutePos.getLowerLeftY()).floatValue());
        float size = ((Float)QR_CODE_RECTANGLE.getWidth()).floatValue();
        image.scaleToFit(size, size);
        PdfContentByte canvas = writer.getDirectContent();
        canvas.addImage(image);
    }

    private void addInformationSection(PdfWriter writer, QrInvoice qrInvoice) throws DocumentException {
        PaymentReference paymentReference;
        if (System.getProperty("QrInvoice.DebugPaymentPartLayout") != null) {
            this.informationSectionRect.setBorder(15);
            this.informationSectionRect.setBorderWidth(0.5f);
            this.informationSectionRect.setBorderColor(BaseColor.BLACK);
            writer.getDirectContent().rectangle(this.informationSectionRect);
        }
        PdfContentByte cb = writer.getDirectContent();
        ColumnText ct = new ColumnText(cb);
        ct.setSimpleColumn(this.informationSectionRect);
        ct.setLeading(((Float)FIXED_LEADINGS.get(this.getOptions().getLayout())).floatValue(), ((Float)MULTIPLIED_LEADINGS.get(this.getOptions().getLayout())).floatValue());
        ct.addText(this.chunk(this.getLabel("CdtrInf.IBAN"), this.headingFont).setLineHeight(6.0f));
        ct.addText(this.chunk("\n", this.valueFont));
        ct.addText(this.chunk(IbanUtils.formatIban((String)qrInvoice.getCreditorInformation().getIban()), this.valueFont));
        ct.addText(this.chunk("\n", this.valueFont));
        ct.addText(this.chunk(this.getLabel("CdtrInf.Cdtr"), this.headingFont));
        ct.addText(this.chunk("\n", this.valueFont));
        AddressUtils.toAddress((Address)qrInvoice.getCreditorInformation().getCreditor()).forEach(addressLine -> {
            ct.addText(this.chunk((String)addressLine, this.valueFont));
            ct.addText(this.chunk("\n", this.valueFont));
        });
        if (qrInvoice.getUltimateCreditor() != null && !qrInvoice.getUltimateCreditor().isEmpty()) {
            ct.addText(this.chunk(this.getLabel("UltmtCdtr"), this.headingFont));
            ct.addText(this.chunk("\n", this.valueFont));
            AddressUtils.toAddress((Address)qrInvoice.getUltimateCreditor()).forEach(addressLine -> {
                ct.addText(this.chunk((String)addressLine, this.valueFont));
                ct.addText(this.chunk("\n", this.valueFont));
            });
        }
        if ((paymentReference = qrInvoice.getPaymentReference()) != null) {
            if (paymentReference.getReferenceType() != null) {
                switch (paymentReference.getReferenceType()) {
                    case QR_REFERENCE: 
                    case CREDITOR_REFERENCE: {
                        ct.addText(this.chunk(this.getLabel("RmtInf.Ref"), this.headingFont));
                        ct.addText(this.chunk("\n", this.valueFont));
                        ct.addText(this.chunk(paymentReference.getReference(), this.valueFont));
                        ct.addText(this.chunk("\n", this.valueFont));
                        break;
                    }
                }
            }
            if (paymentReference.getUnstructuredMessage() != null) {
                ct.addText(this.chunk(this.getLabel("RmtInf.Ustrd"), this.headingFont));
                ct.addText(this.chunk("\n", this.valueFont));
                ct.addText(this.chunk(paymentReference.getUnstructuredMessage(), this.valueFont));
                ct.addText(this.chunk("\n", this.valueFont));
            }
        }
        ct.addText(this.chunk(this.getLabel("UltmtDbtr"), this.headingFont));
        ct.addText(this.chunk("\n", this.valueFont));
        if (qrInvoice.getUltimateDebtor() == null || qrInvoice.getUltimateDebtor().isEmpty()) {
            ct.go();
            float leftX = this.informationSectionRect.getLeft();
            float upperY = ct.getYLine() - ((Float)FIXED_LEADINGS.get(this.getOptions().getLayout())).floatValue();
            float lowerY = upperY - ((Float)DEBTOR_FIELD.getHeight()).floatValue();
            Rect debtorField = DEBTOR_FIELD.toRectangle((Number)Float.valueOf(leftX), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(ct.getCanvas(), (Rect<Float>)debtorField);
            ct.addText(new Chunk("\n", this.valueFont).setLineHeight(((Float)DEBTOR_FIELD.getHeight()).floatValue() + ((Float)FIXED_LEADINGS.get(this.getOptions().getLayout())).floatValue()));
        } else {
            AddressUtils.toAddress((Address)qrInvoice.getUltimateDebtor()).forEach(addressLine -> {
                ct.addText(this.chunk((String)addressLine, this.valueFont));
                ct.addText(this.chunk("\n", this.valueFont));
            });
        }
        LocalDate date = qrInvoice.getPaymentAmountInformation().getDate();
        if (date != null) {
            ct.addText(this.chunk(this.getLabel("CcyAmtDate.ReqdExctnDt"), this.headingFont));
            ct.addText(this.chunk("\n", this.valueFont));
            ct.addText(this.chunk(date.format(DATE_FORMATTER), this.valueFont));
        }
        switch (ct.go(false)) {
            case 1: {
                break;
            }
            case 2: {
                if (System.getProperty("QrInvoice.IgnoreLayoutErrors") != null) break;
                throw new LayoutException("Not all content could be printed to the information section");
            }
        }
    }

    private void addAmount(PdfWriter writer, PaymentAmountInformation paymentAmountInformation) {
        float lowerY = QUIET_SPACE_PTS;
        float upperY = lowerY + ((Float)AMOUNT_FIELD.getHeight()).floatValue();
        PdfContentByte canvas = writer.getDirectContent();
        canvas.setFontAndSize(this.headingFont.getBaseFont(), 6.0f);
        canvas.beginText();
        float currencyX = ((Float)this.rootLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS;
        float amountX = ((Float)this.rootLowerLeft.getX()).floatValue() + QUIET_SPACE_PTS + Utilities.millimetersToPoints((float)12.0f);
        float headerY = upperY + 5.0f;
        canvas.showTextAligned(0, this.getLabel("Currency"), currencyX, headerY, 0.0f);
        canvas.showTextAligned(0, this.getLabel("Amount"), amountX, headerY, 0.0f);
        canvas.endText();
        canvas.setFontAndSize(this.valueFont.getBaseFont(), 8.0f);
        canvas.beginText();
        float valuesY = upperY - 10.0f;
        canvas.showTextAligned(0, paymentAmountInformation.getCurrency().getCurrencyCode(), currencyX, valuesY, 0.0f);
        if (paymentAmountInformation.getAmount() != null) {
            String formattedAmount = DecimalFormatFactory.createPrintAmountFormat().format(paymentAmountInformation.getAmount());
            canvas.showTextAligned(0, formattedAmount, amountX, valuesY, 0.0f);
        }
        canvas.endText();
        if (paymentAmountInformation.getAmount() == null) {
            Rect rect = AMOUNT_FIELD.toRectangle((Number)Float.valueOf(amountX), (Number)Float.valueOf(lowerY));
            this.writeFreeTextBox(canvas, (Rect<Float>)rect);
        }
    }

    private void writeFreeTextBox(PdfContentByte canvas, Rect<Float> rect) {
        float cornerLength = BOX_CORNER_LINE_LENGTH;
        float leftX = ((Float)rect.getLowerLeftX()).floatValue();
        float lowerY = ((Float)rect.getLowerLeftY()).floatValue();
        float rightX = ((Float)rect.getUpperRightX()).floatValue();
        float upperY = ((Float)rect.getUpperRightY()).floatValue();
        canvas.setColorStroke(BaseColor.BLACK);
        canvas.setLineWidth(0.5f);
        canvas.moveTo(leftX + cornerLength, lowerY);
        canvas.lineTo(leftX, lowerY);
        canvas.lineTo(leftX, lowerY + cornerLength);
        canvas.moveTo(leftX + cornerLength, upperY);
        canvas.lineTo(leftX, upperY);
        canvas.lineTo(leftX, upperY - cornerLength);
        canvas.moveTo(rightX - cornerLength, upperY);
        canvas.lineTo(rightX, upperY);
        canvas.lineTo(rightX, upperY - cornerLength);
        canvas.moveTo(rightX - cornerLength, lowerY);
        canvas.lineTo(rightX, lowerY);
        canvas.lineTo(rightX, lowerY + cornerLength);
    }

    private void drawPaymentPartBoundaryLines(PdfContentByte canvas) {
        if (this.getOptions().isPaymentPartBoundaryLines()) {
            float llx = ((Float)this.rootLowerLeft.getX()).floatValue();
            float lly = ((Float)this.rootLowerLeft.getY()).floatValue();
            float ulx = llx;
            float uly = lly + IText5PaymentPartWriter.getPaymentPartHeight();
            float urx = llx + IText5PaymentPartWriter.getPaymentPartWidth();
            float ury = uly;
            canvas.moveTo(llx, lly);
            canvas.setColorStroke(BaseColor.BLACK);
            canvas.setLineWidth(0.5f);
            canvas.lineTo(ulx, uly);
            canvas.moveTo(ulx, uly);
            canvas.lineTo(urx, ury);
            canvas.closePathStroke();
        }
    }

    private Chunk chunk(String text, Font font) {
        Chunk chunk = new Chunk(text, font);
        Function<String, Float> widthFunction = str -> Float.valueOf(font.getBaseFont().getWidthPoint(str, font.getSize()));
        this.applyOptimalLineSplitting(text, this.informationSectionRect.getWidth(), widthFunction, () -> chunk.setSplitCharacter((SplitCharacter)SPLIT_ON_ALL_CHARACTERS));
        return chunk;
    }

    private Rectangle itextRectangle(Rect<Float> rect) {
        return new Rectangle(((Float)rect.getLowerLeftX()).floatValue(), ((Float)rect.getLowerLeftY()).floatValue(), ((Float)rect.getUpperRightX()).floatValue(), ((Float)rect.getUpperRightY()).floatValue());
    }

    private static final class SplitOnAllCharacters
    implements SplitCharacter {
        private SplitOnAllCharacters() {
        }

        public boolean isSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
            return true;
        }
    }
}

